package gov.va.med.mhv.sm.admin.jpa.repository;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.mhv.sm.admin.jpa.model.Facility;
import gov.va.med.mhv.sm.admin.jpa.model.TriageRelation;

@Repository
public interface FacilityRepository extends JpaRepository<Facility, Long> {

	@Query("select fa from Facility fa where fa.name like 'VISN%' order by fa.id")
	List<Facility> getVisns();
	
	@Query("select fa from Facility fa"
          +" where (fa.parentId in (select parent.id from Facility parent where parent.id = :visnId" 
          +" and parent.name like 'VISN%') or fa.visnId = :visnId)"
          +" and length(fa.stationNumber) = 3 order by fa.name")
	List<Facility> getFacilityByVisn(@Param("visnId") Long visnId);
}